"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.colorMix = exports.cloneWithAccessors = void 0;
exports.lightDark = lightDark;
var _culori = require("culori");
const colorMix = (color, weight, mixColor) => {
  const parsedWeight = typeof weight === "string" ? parseFloat(weight) / 100 : weight;
  if (mixColor === "#00000000") {
    const parsedColor = (0, _culori.parse)(color);
    if (parsedColor === void 0) {
      return color;
    }
    return (0, _culori.formatHex8)({
      ...parsedColor,
      alpha: parsedWeight * (parsedColor.alpha ?? 1)
    });
  }
  return (0, _culori.formatHex)((0, _culori.interpolate)([mixColor, color])(parsedWeight));
};
exports.colorMix = colorMix;
function lightDark(light, dark) {
  if (this.currentThemeName === "dark") {
    return dark;
  }
  return light;
}
const cloneWithAccessors = obj => {
  const proto = Object.getPrototypeOf(obj);
  const clone = Object.create(proto);
  Object.defineProperties(clone, Object.getOwnPropertyDescriptors(obj));
  return clone;
};
exports.cloneWithAccessors = cloneWithAccessors;