import { FetchWrapper } from '../utils/FetchWrapper';
export interface RegisterShareParams {
    id: string;
    country?: string;
    locale?: string;
    q?: string;
}
export declare class RegisterShareService {
    private fetchWrapper;
    constructor(fetchWrapper: FetchWrapper);
    /**
     * Registers a user's sharing of a GIF or sticker.
     *
     * @param params - An object containing the parameters for the request, including the ID of the shared object.
     * @returns A promise that resolves when the share is registered.
     *          The API response does not include a body, so the success is determined by the HTTP status code.
     */
    registerShare(params: RegisterShareParams): Promise<void>;
}
