import { FetchWrapper } from '../utils/FetchWrapper';
import { ResponseObject } from './interfaces/ResponseObject';
export interface FeaturedParams {
    searchfilter?: string;
    country?: string;
    locale?: string;
    media_filter?: string;
    ar_range?: 'all' | 'wide' | 'standard';
    contentfilter?: 'off' | 'low' | 'medium' | 'high';
    limit?: number;
    pos?: string;
}
export interface FeaturedResponse {
    next: string;
    results: ResponseObject[];
}
export declare class FeaturedService {
    private fetchWrapper;
    constructor(fetchWrapper: FetchWrapper);
    /**
     * Fetches a list of current global featured GIFs or stickers from the Tenor API.
     *
     * @param params - An object containing the parameters for the request.
     * @returns A promise that resolves to a FeaturedResponse containing the featured GIFs or stickers.
     */
    getFeatured(params?: FeaturedParams): Promise<FeaturedResponse>;
    /**
     * Fetches the next page of featured results based on the provided next token.
     *
     * @param next - The next page token from a previous featured response.
     * @returns A promise that resolves to a FeaturedResponse containing the next set of featured results.
     */
    fetchNext(next: string): Promise<FeaturedResponse>;
}
