type ProfilerOptions = {
    sampleInterval: number;
    maxBufferSize: number;
};
type Profiler = {
    new (options: ProfilerOptions): Profiler;
    stop(): Promise<ProfilingTrace>;
};
declare global {
    const Profiler: Profiler;
    interface Window {
        Profiler: Profiler;
    }
}
type Sample = {
    stackId?: number;
    timestamp: number;
};
type Stack = {
    frameId: number;
    parentId?: number;
};
type Frame = {
    name: string;
    line?: number;
    column?: number;
    resourceId?: number;
};
type ProfilingTrace = {
    frames: Frame[];
    resources: string[];
    samples: Sample[];
    stacks: Stack[];
};
export declare function startProfiling(): boolean;
export declare function stopProfiling(saveToDownloads?: boolean, fileName?: string): Promise<string>;
export {};
//# sourceMappingURL=index.web.d.ts.map