import { TNodeShape, TNodeType } from '@native-html/transient-render-engine';
/**
 * A utility to separate box model styles and other styles. Useful when one wants
 * to wrap a text element in a view to benefit from padding vertical,
 * borders... etc.
 *
 * @param styles - The native styles to split.
 */
export default function splitBoxModelStyle(style: ReturnType<TNodeShape<TNodeType>['getNativeStyles']>): {
    boxModelStyle: Pick<import("@native-html/transient-render-engine").NativeTextStyles | import("@native-html/transient-render-engine").NativeBlockStyles, "transform" | "transformOrigin" | "backfaceVisibility" | "backgroundColor" | "borderBottomColor" | "borderLeftColor" | "borderRightColor" | "borderTopColor" | "borderBlockColor" | "borderBlockEndColor" | "borderBlockStartColor" | "borderBottomLeftRadius" | "borderBottomRightRadius" | "borderEndEndRadius" | "borderEndStartRadius" | "borderStartEndRadius" | "borderStartStartRadius" | "borderTopLeftRadius" | "borderTopRightRadius" | "borderStyle" | "borderBottomWidth" | "borderLeftWidth" | "borderRightWidth" | "borderTopWidth" | "opacity" | "outlineColor" | "outlineOffset" | "outlineStyle" | "outlineWidth" | "pointerEvents" | "cursor" | "boxShadow" | "filter" | "mixBlendMode" | "isolation" | "display" | "width" | "height" | "bottom" | "left" | "right" | "top" | "insetBlockEnd" | "insetBlockStart" | "insetInlineEnd" | "insetInlineStart" | "minWidth" | "maxWidth" | "minHeight" | "maxHeight" | "marginBlockEnd" | "marginBlockStart" | "marginBottom" | "marginInlineEnd" | "marginInlineStart" | "marginLeft" | "marginRight" | "marginTop" | "paddingBlockEnd" | "paddingBlockStart" | "paddingBottom" | "paddingInlineEnd" | "paddingInlineStart" | "paddingLeft" | "paddingRight" | "paddingTop" | "flexDirection" | "flexWrap" | "justifyContent" | "alignItems" | "alignSelf" | "alignContent" | "flexGrow" | "flexShrink" | "flexBasis" | "aspectRatio" | "boxSizing" | "zIndex" | "direction" | "rowGap" | "columnGap">;
    otherStyle: Omit<import("@native-html/transient-render-engine").NativeTextStyles | import("@native-html/transient-render-engine").NativeBlockStyles, string>;
};
//# sourceMappingURL=splitBoxModelStyle.d.ts.map