"use strict";

import React, { useMemo } from 'react';
import IMGElement from "../elements/IMGElement.js";
import { useComputeMaxWidthForTag } from "../context/SharedPropsProvider.js";
import { StyleSheet } from 'react-native';
import useNormalizedUrl from "../hooks/useNormalizedUrl.js";
import { useRendererProps } from "../context/RenderersPropsProvider.js";
import useContentWidth from "../hooks/useContentWidth.js";
import getNativePropsForTNode from "../helpers/getNativePropsForTNode.js";

/**
 * A hook to produce props consumable by {@link IMGElement} component
 * from custom renderer props.
 */
export function useIMGElementProps(props) {
  const {
    tnode
  } = props;
  const contentWidth = useContentWidth();
  const {
    initialDimensions,
    enableExperimentalPercentWidth
  } = useRendererProps('img');
  const computeImagesMaxWidth = useComputeMaxWidthForTag('img');
  const src = tnode.attributes.src || '';
  const source = {
    uri: useNormalizedUrl(src)
  };
  const {
    style: rawStyle,
    ...containerProps
  } = getNativePropsForTNode(props);
  const style = useMemo(() => rawStyle ? StyleSheet.flatten(rawStyle) : {}, [rawStyle]);
  return {
    contentWidth,
    containerProps,
    enableExperimentalPercentWidth,
    initialDimensions,
    source,
    style,
    testID: 'img',
    computeMaxWidth: computeImagesMaxWidth,
    alt: tnode.attributes.alt,
    altColor: tnode.styles.nativeTextFlow.color,
    width: tnode.attributes.width,
    height: tnode.attributes.height,
    objectFit: tnode.styles.webBlockRet.objectFit
  };
}
const IMGRenderer = props => {
  return /*#__PURE__*/React.createElement(IMGElement, useIMGElementProps(props));
};
export default IMGRenderer;
//# sourceMappingURL=IMGRenderer.js.map