"use strict";

import mergeCollapsedMargins from "../helpers/mergeCollapsedMargins.js";
import { useRendererConfig } from "../context/RenderRegistryProvider.js";
import { useDefaultContainerProps } from "../context/SharedPropsProvider.js";

/**
 * @internal
 */
export default function useAssembledCommonProps({
  tnode,
  propsFromParent,
  sharedProps,
  renderIndex,
  renderLength,
  TNodeChildrenRenderer
}, TDefault) {
  const {
    Default,
    Custom
  } = useRendererConfig(tnode);
  const containerProps = useDefaultContainerProps();
  const assembledProps = {
    tnode,
    propsFromParent,
    sharedProps,
    TDefaultRenderer: TDefault,
    TNodeChildrenRenderer,
    style: mergeCollapsedMargins(propsFromParent?.collapsedMarginTop, tnode.getNativeStyles()),
    type: tnode.type === 'text' || tnode.type === 'phrasing' ? 'text' : 'block',
    propsForChildren: tnode.tagName ? {} : propsFromParent,
    InternalRenderer: Default || TDefault,
    renderIndex,
    renderLength,
    ...containerProps
  };
  return {
    assembledProps,
    Renderer: Custom || Default || null
  };
}
//# sourceMappingURL=useAssembledCommonProps.js.map