"use strict";

import { stringifyEntitiesLight } from 'stringify-entities';
import { isDomText, isDomElement } from '@native-html/transient-render-engine';
function renderOpeningTag(tag, attributes) {
  const strAttributes = [];
  Object.keys(attributes).forEach(key => {
    strAttributes.push(`${key}="${stringifyEntitiesLight(`${attributes[key]}`)}"`);
  });
  return `<${tag}${strAttributes.length ? ' ' : ''}${strAttributes.join(' ')}>`;
}

/**
 * Convert a DOM node to its HTML representation.
 *
 * @param root - The root to stringify.
 * @param reporter - An optional function which will receive every
 * parsed node as 1st argument, the depth as 2d argument and the converted html
 * as 3d argument.
 */
export default function domNodeToHTMLString(root, reporter, depth = 0) {
  root = root ?? null;
  let html = '';
  if (isDomElement(root)) {
    const strChildren = root.children.reduce((prev, curr) => {
      const convertedNode = domNodeToHTMLString(curr, reporter, depth + 1);
      return `${prev}${convertedNode}`;
    }, '');
    html = `${renderOpeningTag(root.tagName, root.attribs)}${strChildren}</${root.tagName}>`;
  } else if (isDomText(root)) {
    const text = stringifyEntitiesLight(root.data);
    html = text;
  }
  typeof reporter === 'function' && reporter(root, depth, html);
  return html;
}

/**
 * @public
 */
//# sourceMappingURL=domNodeToHTMLString.js.map