"use strict";

import defaultImageInitialDimensions from "./defaultInitialImageDimensions.js";
import { getIMGState } from "./getIMGState.js";
import useImageConcreteDimensions from "./useImageConcreteDimensions.js";
import useImageSpecifiedDimensions from "./useImageSpecifiedDimensions.js";
import useIMGNormalizedSource from "./useIMGNormalizedSource.js";

/**
 * This hook is useful when one has access to image natural dimensions prior to
 * loading. The `cachedNaturalDimensions` prop must be passed to immediately
 * compute concrete dimensions.
 */
export default function useIMGElementStateWithCache(props) {
  const {
    alt,
    altColor,
    source,
    contentWidth,
    computeMaxWidth,
    objectFit,
    initialDimensions = defaultImageInitialDimensions,
    cachedNaturalDimensions
  } = props;
  const {
    flatStyle,
    specifiedDimensions
  } = useImageSpecifiedDimensions(props);
  const nomalizedSource = useIMGNormalizedSource({
    specifiedDimensions,
    source
  });
  const concreteDimensions = useImageConcreteDimensions({
    flatStyle,
    naturalDimensions: cachedNaturalDimensions,
    specifiedDimensions,
    computeMaxWidth,
    contentWidth
  });
  return getIMGState({
    error: null,
    concreteDimensions,
    containerStyle: flatStyle,
    initialDimensions,
    objectFit,
    source: nomalizedSource,
    alt,
    altColor
  });
}
//# sourceMappingURL=useIMGElementStateWithCache.js.map