"use strict";

import extractImageStyleProps from "./extractImageStyleProps.js";
export function getIMGState({
  error,
  alt,
  altColor,
  source,
  containerStyle,
  concreteDimensions,
  initialDimensions,
  objectFit,
  onError
}) {
  if (error) {
    return {
      type: 'error',
      alt,
      altColor,
      source,
      error,
      containerStyle,
      dimensions: concreteDimensions ?? initialDimensions
    };
  }
  if (concreteDimensions != null) {
    return {
      type: 'success',
      alt,
      altColor,
      source,
      onError,
      containerStyle,
      imageStyle: extractImageStyleProps(containerStyle, objectFit),
      dimensions: concreteDimensions
    };
  }
  return {
    type: 'loading',
    alt,
    altColor,
    source,
    containerStyle,
    dimensions: initialDimensions
  };
}
//# sourceMappingURL=getIMGState.js.map