"use strict";

import { StyleSheet, Text, View } from 'react-native';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
const styles = StyleSheet.create({
  altBox: {
    borderWidth: StyleSheet.hairlineWidth,
    overflow: 'hidden',
    justifyContent: 'center'
  },
  altText: {
    textAlign: 'center',
    fontStyle: 'italic'
  }
});

/**
 * Alt view for the {@link IMGElement} component.
 */
export default function IMGElementContentAlt({
  dimensions,
  alt,
  altColor,
  testID,
  children
}) {
  return /*#__PURE__*/_jsxs(View, {
    style: [styles.altBox, dimensions, {
      borderColor: altColor
    }],
    accessibilityRole: "image",
    accessibilityLabel: alt,
    testID: testID,
    children: [/*#__PURE__*/_jsx(Text, {
      style: [styles.altText, {
        color: altColor
      }],
      children: alt
    }), children]
  });
}
//# sourceMappingURL=IMGElementContentAlt.js.map