"use strict";

import React, { useMemo } from 'react';
import { View, StyleSheet } from 'react-native';
import GenericPressable from "../GenericPressable.js";
const styles = StyleSheet.create({
  container: {
    flexDirection: 'row',
    alignSelf: 'stretch',
    justifyContent: 'center'
  }
});

/**
 * Container for the {@link IMGElement} component.
 */
export default function IMGElementContainer({
  style,
  onPress,
  testID,
  children,
  ...otherProps
}) {
  const containerStyle = useMemo(() => {
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    const {
      width,
      height,
      ...remainingStyle
    } = style;
    return [styles.container, remainingStyle];
  }, [style]);
  const Container = typeof onPress === 'function' ? GenericPressable : View;
  return /*#__PURE__*/React.createElement(Container, {
    ...otherProps,
    style: containerStyle,
    onPress,
    testID
  }, children);
}
//# sourceMappingURL=IMGElementContainer.js.map