"use strict";

import React, { useEffect } from 'react';
import RenderTTree from "./RenderTTree.js";
function useInlineSourceLoader({
  source,
  onHTMLLoaded
}) {
  const html = source.html;
  useEffect(() => {
    html && onHTMLLoaded?.call(null, html);
  }, [html, onHTMLLoaded]);
  return source;
}
export default function SourceLoaderInline(props) {
  const {
    html
  } = useInlineSourceLoader(props);
  return /*#__PURE__*/React.createElement(RenderTTree, {
    document: html,
    baseUrl: props.source.baseUrl
  });
}
//# sourceMappingURL=SourceLoaderInline.js.map