function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import Rea from "../external/reanimated/ReanimatedProxy";
import { HAS_REANIMATED_3 } from "../external/reanimated/renderHelpers";
import { ReanimatedRecorder } from "./Recorder/ReanimatedRecorder";
import { Container, StaticContainer } from "./StaticContainer";
import { visit } from "./Recorder/Visitor";
import "../skia/NativeSetup";
import "../views/api";
const nativeDrawOnscreen = (nativeId, recorder, onSize) => {
  "worklet";

  if (onSize) {
    SkiaViewApi.setJsiProperty(nativeId, "onSize", onSize);
  }
  //const start = performance.now();
  const picture = recorder.play();
  //const end = performance.now();
  //console.log("Recording time: ", end - start);
  SkiaViewApi.setJsiProperty(nativeId, "picture", picture);
};
class NativeReanimatedContainer extends Container {
  constructor(Skia, nativeId, onSize) {
    super(Skia);
    this.nativeId = nativeId;
    this.onSize = onSize;
    _defineProperty(this, "mapperId", null);
  }
  redraw() {
    if (this.mapperId !== null) {
      Rea.stopMapper(this.mapperId);
    }
    if (this.unmounted) {
      return;
    }
    const {
      nativeId,
      Skia
    } = this;
    const recorder = new ReanimatedRecorder(Skia);
    visit(recorder, this.root);
    const sharedValues = recorder.getSharedValues();
    const sharedRecorder = recorder.getRecorder();
    Rea.runOnUI(onSize => {
      "worklet";

      nativeDrawOnscreen(nativeId, sharedRecorder, onSize);
    })(this.onSize);
    if (sharedValues.length > 0) {
      const {
        onSize
      } = this;
      this.mapperId = Rea.startMapper(() => {
        "worklet";

        sharedRecorder.applyUpdates(sharedValues);
        nativeDrawOnscreen(nativeId, sharedRecorder, onSize);
      }, sharedValues);
    }
  }
}
export const createContainer = (Skia, nativeId, onSize) => {
  if (HAS_REANIMATED_3 && nativeId !== -1) {
    return new NativeReanimatedContainer(Skia, nativeId, onSize);
  } else {
    return new StaticContainer(Skia, nativeId);
  }
};
//# sourceMappingURL=Container.native.js.map