import type { FC, RefObject } from "react";
import React from "react";
import type { MeasureInWindowOnSuccessCallback, MeasureOnSuccessCallback, ViewProps } from "react-native";
import { type SharedValue } from "react-native-reanimated";
import type { SkImage, SkRect, SkSize } from "../skia/types";
export interface CanvasRef extends FC<CanvasProps> {
    makeImageSnapshot(rect?: SkRect): SkImage;
    makeImageSnapshotAsync(rect?: SkRect): Promise<SkImage>;
    redraw(): void;
    getNativeId(): number;
    measure(callback: MeasureOnSuccessCallback): void;
    measureInWindow(callback: MeasureInWindowOnSuccessCallback): void;
}
export declare const useCanvasRef: () => RefObject<CanvasRef | null>;
export declare const useCanvasSize: (userRef?: RefObject<CanvasRef | null>) => {
    ref: RefObject<CanvasRef | null>;
    size: SkSize;
};
export declare const isFabric: boolean;
export interface CanvasProps extends Omit<ViewProps, "onLayout"> {
    debug?: boolean;
    opaque?: boolean;
    onSize?: SharedValue<SkSize>;
    colorSpace?: "p3" | "srgb";
    ref?: React.Ref<CanvasRef>;
    __destroyWebGLContextAfterRender?: boolean;
}
export declare const Canvas: ({ debug, opaque, children, onSize, colorSpace, ref, onLayout, ...viewProps }: CanvasProps) => React.JSX.Element;
