"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createContainer = void 0;
var _ReanimatedProxy = _interopRequireDefault(require("../external/reanimated/ReanimatedProxy"));
var _renderHelpers = require("../external/reanimated/renderHelpers");
var _ReanimatedRecorder = require("./Recorder/ReanimatedRecorder");
var _StaticContainer = require("./StaticContainer");
var _Visitor = require("./Recorder/Visitor");
require("../skia/NativeSetup");
require("../views/api");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const nativeDrawOnscreen = (nativeId, recorder, onSize) => {
  "worklet";

  if (onSize) {
    SkiaViewApi.setJsiProperty(nativeId, "onSize", onSize);
  }
  //const start = performance.now();
  const picture = recorder.play();
  //const end = performance.now();
  //console.log("Recording time: ", end - start);
  SkiaViewApi.setJsiProperty(nativeId, "picture", picture);
};
class NativeReanimatedContainer extends _StaticContainer.Container {
  constructor(Skia, nativeId, onSize) {
    super(Skia);
    this.nativeId = nativeId;
    this.onSize = onSize;
    _defineProperty(this, "mapperId", null);
  }
  redraw() {
    if (this.mapperId !== null) {
      _ReanimatedProxy.default.stopMapper(this.mapperId);
    }
    if (this.unmounted) {
      return;
    }
    const {
      nativeId,
      Skia
    } = this;
    const recorder = new _ReanimatedRecorder.ReanimatedRecorder(Skia);
    (0, _Visitor.visit)(recorder, this.root);
    const sharedValues = recorder.getSharedValues();
    const sharedRecorder = recorder.getRecorder();
    _ReanimatedProxy.default.runOnUI(onSize => {
      "worklet";

      nativeDrawOnscreen(nativeId, sharedRecorder, onSize);
    })(this.onSize);
    if (sharedValues.length > 0) {
      const {
        onSize
      } = this;
      this.mapperId = _ReanimatedProxy.default.startMapper(() => {
        "worklet";

        sharedRecorder.applyUpdates(sharedValues);
        nativeDrawOnscreen(nativeId, sharedRecorder, onSize);
      }, sharedValues);
    }
  }
}
const createContainer = (Skia, nativeId, onSize) => {
  if (_renderHelpers.HAS_REANIMATED_3 && nativeId !== -1) {
    return new NativeReanimatedContainer(Skia, nativeId, onSize);
  } else {
    return new _StaticContainer.StaticContainer(Skia, nativeId);
  }
};
exports.createContainer = createContainer;
//# sourceMappingURL=Container.native.js.map