"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsiSkParagraph = void 0;
var _Host = require("./Host");
var _JsiSkRect = require("./JsiSkRect");
class JsiSkParagraph extends _Host.HostObject {
  constructor(CanvasKit, ref) {
    super(CanvasKit, ref, "Paragraph");
  }
  getMinIntrinsicWidth() {
    return this.ref.getMinIntrinsicWidth();
  }
  getMaxIntrinsicWidth() {
    return this.ref.getMaxIntrinsicWidth();
  }
  getLongestLine() {
    return this.ref.getLongestLine();
  }
  layout(width) {
    this.ref.layout(width);
  }
  paint(canvas, x, y) {
    canvas.ref.drawParagraph(this.ref, x, y);
  }
  getHeight() {
    return this.ref.getHeight();
  }
  getMaxWidth() {
    return this.ref.getMaxWidth();
  }
  getGlyphPositionAtCoordinate(x, y) {
    return this.ref.getGlyphPositionAtCoordinate(x, y).pos;
  }
  getRectsForPlaceholders() {
    return this.ref.getRectsForPlaceholders().map(({
      rect,
      dir
    }) => ({
      rect: new _JsiSkRect.JsiSkRect(this.CanvasKit, rect),
      direction: dir.value
    }));
  }
  getRectsForRange(start, end) {
    return this.ref.getRectsForRange(start, end, {
      value: 0
    } /** kTight */, {
      value: 0
    } /** kTight */).map(({
      rect
    }) => new _JsiSkRect.JsiSkRect(this.CanvasKit, rect));
  }
  getLineMetrics() {
    return this.ref.getLineMetrics();
  }
  dispose() {
    this.ref.delete();
  }
}
exports.JsiSkParagraph = JsiSkParagraph;
//# sourceMappingURL=JsiSkParagraph.js.map