"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanvasSize = exports.useCanvasRef = exports.isFabric = exports.Canvas = void 0;
var _react = _interopRequireWildcard(require("react"));
var _SkiaViewNativeId = require("../views/SkiaViewNativeId");
var _SkiaPictureViewNativeComponent = _interopRequireDefault(require("../specs/SkiaPictureViewNativeComponent"));
var _Reconciler = require("../sksg/Reconciler");
var _skia = require("../skia");
var _Platform = require("../Platform");
var _global;
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const useCanvasRef = () => (0, _react.useRef)(null);
exports.useCanvasRef = useCanvasRef;
const useCanvasSize = userRef => {
  const ourRef = useCanvasRef();
  const ref = userRef !== null && userRef !== void 0 ? userRef : ourRef;
  const [size, setSize] = (0, _react.useState)({
    width: 0,
    height: 0
  });
  (0, _react.useLayoutEffect)(() => {
    if (ref.current) {
      ref.current.measure((_x, _y, width, height) => {
        setSize({
          width,
          height
        });
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    ref,
    size
  };
};

// eslint-disable-next-line @typescript-eslint/no-explicit-any
exports.useCanvasSize = useCanvasSize;
const isFabric = exports.isFabric = Boolean((_global = global) === null || _global === void 0 ? void 0 : _global.nativeFabricUIManager);
const Canvas = ({
  debug,
  opaque,
  children,
  onSize,
  colorSpace = "p3",
  ref,
  // Here know this is a type error but this is done on purpose to check it at runtime
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-expect-error
  onLayout,
  ...viewProps
}) => {
  if (onLayout && isFabric) {
    console.error(
    // eslint-disable-next-line max-len
    "<Canvas onLayout={onLayout} /> is not supported on the new architecture, to fix the issue, see: https://shopify.github.io/react-native-skia/docs/canvas/overview/#getting-the-canvas-size");
  }
  const viewRef = (0, _react.useRef)(null);
  // Native ID
  const nativeId = (0, _react.useMemo)(() => {
    return _SkiaViewNativeId.SkiaViewNativeId.current++;
  }, []);

  // Root
  const root = (0, _react.useMemo)(() => new _Reconciler.SkiaSGRoot(_skia.Skia, nativeId, onSize), [nativeId, onSize]);

  // Render effects
  (0, _react.useLayoutEffect)(() => {
    root.render(children);
  }, [children, root, nativeId]);
  (0, _react.useEffect)(() => {
    return () => {
      root.unmount();
    };
  }, [root]);

  // Component methods
  (0, _react.useImperativeHandle)(ref, () => ({
    makeImageSnapshot: rect => {
      return SkiaViewApi.makeImageSnapshot(nativeId, rect);
    },
    makeImageSnapshotAsync: rect => {
      return SkiaViewApi.makeImageSnapshotAsync(nativeId, rect);
    },
    redraw: () => {
      SkiaViewApi.requestRedraw(nativeId);
    },
    getNativeId: () => {
      return nativeId;
    },
    measure: callback => {
      var _viewRef$current;
      (_viewRef$current = viewRef.current) === null || _viewRef$current === void 0 || _viewRef$current.measure(callback);
    },
    measureInWindow: callback => {
      var _viewRef$current2;
      (_viewRef$current2 = viewRef.current) === null || _viewRef$current2 === void 0 || _viewRef$current2.measureInWindow(callback);
    }
  }));
  const onLayoutWeb = (0, _react.useCallback)(e => {
    if (onLayout) {
      onLayout(e);
    }
    if (_Platform.Platform.OS === "web" && onSize) {
      const {
        width,
        height
      } = e.nativeEvent.layout;
      onSize.value = {
        width,
        height
      };
    }
  }, [onLayout, onSize]);
  return /*#__PURE__*/_react.default.createElement(_SkiaPictureViewNativeComponent.default, _extends({
    ref: viewRef,
    collapsable: false,
    nativeID: `${nativeId}`,
    debug: debug,
    opaque: opaque,
    colorSpace: colorSpace,
    onLayout: onLayoutWeb
  }, viewProps));
};
exports.Canvas = Canvas;
//# sourceMappingURL=Canvas.js.map