"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.REACT_NATIVE_CONFIG_FILES = void 0;
exports.resolveCommunityCLI = resolveCommunityCLI;
exports.loadContext = loadContext;
exports.loadContextAsync = loadContextAsync;
exports.readReactNativeConfig = readReactNativeConfig;
const package_1 = require("@rnx-kit/tools-node/package");
const node_child_process_1 = require("node:child_process");
const fs = __importStar(require("node:fs"));
const path = __importStar(require("node:path"));
const cache_ts_1 = require("./cache.js");
// As of 0.76, `@react-native-community/cli` is no longer a dependency of
// `react-native`. Consumers have to take a direct dependency on CLI instead.
const RN_CLI_DECOUPLED = 76;
exports.REACT_NATIVE_CONFIG_FILES = [
    "react-native.config.ts",
    "react-native.config.mjs",
    "react-native.config.cjs",
    "react-native.config.js",
];
function toNumber(version) {
    const [major, minor = 0] = version.split(".");
    return Number(major) * 1000 + Number(minor);
}
function findStartDir(root, reactNativePath = "") {
    const reactNative = reactNativePath ||
        (0, package_1.findPackageDependencyDir)("react-native", {
            startDir: root,
            resolveSymlinks: true,
        });
    if (!reactNative) {
        return root;
    }
    const { version } = (0, package_1.readPackage)(reactNative);
    return toNumber(version) < RN_CLI_DECOUPLED ? reactNative : root;
}
function getConfigOrState(projectRoot) {
    const state = (0, cache_ts_1.getCurrentState)(projectRoot);
    if (state === (0, cache_ts_1.getSavedState)(projectRoot)) {
        const config = (0, cache_ts_1.loadConfigFromCache)(projectRoot);
        if (config) {
            return config;
        }
    }
    return state;
}
function makeLoadConfigOptions(fn, projectRoot) {
    return fn.length === 1
        ? { projectRoot }
        : projectRoot;
}
/**
 * Finds path to `@react-native-community/cli`.
 * @param root Project root
 * @param reactNativePath Path to `react-native`, if known
 */
function resolveCommunityCLI(root, reactNativePath = "") {
    const startDir = findStartDir(root, reactNativePath);
    return require.resolve("@react-native-community/cli", { paths: [startDir] });
}
/**
 * Equivalent to calling `loadConfig()` from `@react-native-community/cli`, but
 * the result is cached for faster subsequent accesses.
 * @param projectRoot Project root; defaults to current working directory
 */
function loadContext(projectRoot = process.cwd()) {
    const state = getConfigOrState(projectRoot);
    if (typeof state !== "string") {
        return state;
    }
    const rncli = resolveCommunityCLI(projectRoot);
    const { loadConfig } = require(rncli);
    const options = makeLoadConfigOptions(loadConfig, projectRoot);
    const config = loadConfig(options);
    (0, cache_ts_1.saveConfigToCache)(projectRoot, state, config);
    return config;
}
/**
 * Equivalent to calling `loadConfigAsync()` (with fallback to `loadConfig()`)
 * from `@react-native-community/cli`, but the result is cached for faster
 * subsequent accesses.
 * @param projectRoot Project root; defaults to current working directory
 */
async function loadContextAsync(projectRoot = process.cwd()) {
    const state = getConfigOrState(projectRoot);
    if (typeof state !== "string") {
        return state;
    }
    const rncli = resolveCommunityCLI(projectRoot);
    const { loadConfig, loadConfigAsync } = require(rncli);
    const options = makeLoadConfigOptions(loadConfig, projectRoot);
    if (!loadConfigAsync) {
        const config = loadConfig(options);
        (0, cache_ts_1.saveConfigToCache)(projectRoot, state, config);
        return config;
    }
    const config = await loadConfigAsync(options);
    (0, cache_ts_1.saveConfigToCache)(projectRoot, state, config);
    return config;
}
function readReactNativeConfig(packageDir, cwd = process.cwd()) {
    for (const configFile of exports.REACT_NATIVE_CONFIG_FILES) {
        const configPath = path.join(packageDir, configFile);
        if (fs.existsSync(configPath)) {
            const url = process.platform === "win32"
                ? `file://${configPath.replaceAll("\\", "/")}`
                : configPath;
            const args = [
                "--no-warnings",
                "--eval",
                `import("${url}").then((config) => console.log(JSON.stringify(config.default ?? config)));`,
            ];
            const { stderr, stdout } = (0, node_child_process_1.spawnSync)(process.argv0, args, { cwd });
            const errors = stderr?.toString().trim();
            if (errors) {
                console.error(`${configPath}: ${errors}`);
            }
            const json = stdout?.toString().trim();
            return json ? JSON.parse(json) : undefined;
        }
    }
    return undefined;
}
//# sourceMappingURL=context.js.map