"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destructureModuleRef = destructureModuleRef;
exports.parsePackageRef = parsePackageRef;
exports.readPackage = readPackage;
exports.writePackage = writePackage;
exports.findPackage = findPackage;
exports.findPackageDir = findPackageDir;
exports.findPackageDependencyDir = findPackageDependencyDir;
exports.resolveDependencyChain = resolveDependencyChain;
const nodefs = __importStar(require("fs"));
const path = __importStar(require("path"));
const path_1 = require("./path");
function getModuleRefParts(ref, found = [], requested = 2, startPos = 0) {
    if (startPos < ref.length) {
        if (requested > 1) {
            const splitAt = ref.indexOf("/", startPos);
            if (splitAt >= 0) {
                requested += startPos === 0 && ref[0] === "@" ? 1 : 0;
                found.push(ref.slice(startPos, splitAt));
                return getModuleRefParts(ref, found, requested - 1, splitAt + 1);
            }
        }
        found.push(ref.slice(startPos));
    }
    return found;
}
/**
 * Destructure a module reference into its component par
 * @param r module reference to destructure
 * @returns either a destructured module reference or undefined if it is a file reference
 */
function destructureModuleRef(r) {
    if (r) {
        const parts = getModuleRefParts(r);
        if (parts.length > 0) {
            // if we only have one term the first term will be treated as the name, even if it is a scope
            if (parts.length === 1) {
                return { name: parts[0] };
            }
            // otherwise split the parts and return them
            const scope = parts[0].startsWith("@") ? parts.shift() : undefined;
            const name = parts.shift();
            const path = parts.shift();
            if (name) {
                return { name, scope, path };
            }
        }
    }
    throw new Error(`Invalid package reference: "${r}"`);
}
/**
 * Parse a package reference string. An example reference is the `name`
 * property found in `package.json`.
 *
 * @param r Package reference string
 * @returns Parsed package reference object
 */
function parsePackageRef(r) {
    const { scope, name, path } = destructureModuleRef(r);
    const fullName = path ? `${name}/${path}` : name;
    return { name: fullName, scope };
}
/**
 * Resolve a package path to a file reference by appending `package.json`, if needed.
 *
 * @param pkgPath Package path. May contain `package.json`.
 * @returns File reference to `package.json`
 */
function resolvePackagePath(pkgPath) {
    if (path.basename(pkgPath).toLowerCase() !== "package.json") {
        return path.join(pkgPath, "package.json");
    }
    return pkgPath;
}
/**
 * Read a `package.json` manifest from a file.
 *
 * @param pkgPath Either a path directly to the target `package.json` file, or the directory containing it.
 * @returns Package manifest
 */
function readPackage(pkgPath, 
/** @internal */ fs = nodefs) {
    const pkgFile = resolvePackagePath(pkgPath);
    return JSON.parse(fs.readFileSync(pkgFile, "utf-8"));
}
/**
 * Write a `package.json` manifest to a file.
 *
 * @param pkgPath Either a path directly to the target `package.json` file, or the directory containing it.
 * @param manifest Package manifest
 * @param space Indentation to apply to the output
 */
function writePackage(pkgPath, manifest, space = "  ", 
/** @internal */ fs = nodefs) {
    const pkgFile = resolvePackagePath(pkgPath);
    fs.writeFileSync(pkgFile, JSON.stringify(manifest, undefined, space) + "\n", "utf-8");
}
/**
 * Find the nearest `package.json` manifest file. Search upward through all
 * parent directories.
 *
 * If a starting directory is given, use it. Otherwise, use the current working
 * directory.
 *
 * @param startDir Optional starting directory for the search. If not given, the current directory is used.
 * @returns Path to `package.json`, or `undefined` if not found.
 */
function findPackage(startDir, 
/** @internal */ fs = nodefs) {
    return (0, path_1.findUp)("package.json", { startDir }, fs);
}
/**
 * Find the parent directory of the nearest `package.json` manifest file. Search
 * upward through all parent directories.
 *
 * If a starting directory is given, use it. Otherwise, use the current working
 * directory.
 *
 * @param startDir Optional starting directory for the search. If not given, the current directory is used.
 * @returns Path to `package.json`, or `undefined` if not found.
 */
function findPackageDir(startDir, 
/** @internal */ fs = nodefs) {
    const manifest = (0, path_1.findUp)("package.json", { startDir }, fs);
    return manifest && path.dirname(manifest);
}
/**
 * Find the package dependency's directory, starting from the given directory
 * and moving outward, through all parent directories.
 *
 * Package dependencies exist under 'node_modules/[`scope`]/[`name`]'.
 *
 * @param ref Package dependency reference
 * @param options Options which control the search
 * @returns Path to the package dependency's directory, or `undefined` if not found.
 */
function findPackageDependencyDir(ref, options, 
/** @internal */ fs = nodefs) {
    const pkgName = typeof ref === "string" ? ref : path.join(ref.scope ?? "", ref.name);
    const packageDir = (0, path_1.findUp)(path.join("node_modules", pkgName), {
        startDir: options?.startDir,
        type: "directory",
        allowSymlinks: options?.allowSymlinks,
    }, fs);
    if (!packageDir || !options?.resolveSymlinks) {
        return packageDir;
    }
    return fs.lstatSync(packageDir).isSymbolicLink()
        ? path.resolve(path.dirname(packageDir), fs.readlinkSync(packageDir))
        : packageDir;
}
/**
 * Resolve the path to a dependency given a chain of dependencies leading up to
 * it.
 * @param chain Chain of dependencies leading up to the target dependency.
 * @param startDir Optional starting directory for the search. If not given, the current directory is used.
 * @returns Path to the final dependency's directory.
 */
function resolveDependencyChain(chain, startDir = process.cwd()) {
    return chain.reduce((startDir, module) => {
        const p = require.resolve(`${module}/package.json`, { paths: [startDir] });
        return path.dirname(p);
    }, startDir);
}
//# sourceMappingURL=package.js.map