"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAssetFile = isAssetFile;
exports.resolveAsset = resolveAsset;
const path = __importStar(require("node:path"));
/**
 * Returns whether the file at specified path is an asset.
 */
function isAssetFile(context, filePath) {
    const assetExts = context.assetExts;
    if (assetExts) {
        for (const ext of assetExts) {
            if (filePath.endsWith(ext)) {
                const dot = filePath.length - ext.length - 1;
                if (filePath[dot] === ".") {
                    return true;
                }
            }
        }
        return false;
    }
    return Boolean(context.isAssetFile?.(filePath));
}
/**
 * Resolve a file path as an asset. Returns the set of files found after
 * expanding asset resolutions (e.g. `icon@2x.png`).
 *
 * @see {@link https://github.com/facebook/metro/commit/6e6f36fd982b9226b7daafd1c942c7be32f9af40}
 */
function resolveAsset(context, filePath) {
    const dirPath = path.dirname(filePath);
    const extension = path.extname(filePath);
    const basename = path.basename(filePath, extension);
    if (!/@\d+(?:\.\d+)?x$/.test(basename)) {
        try {
            const assets = context.resolveAsset(dirPath, basename, extension);
            if (assets != null) {
                return {
                    type: "assetFiles",
                    filePaths: assets,
                };
            }
        }
        catch (_) {
            //
        }
    }
    return {
        type: "assetFiles",
        filePaths: [filePath],
    };
}
//# sourceMappingURL=assets.js.map