"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyOxcResolver = applyOxcResolver;
const assets_1 = require("../utils/assets");
const enhancedResolveHelpers_1 = require("../utils/enhancedResolveHelpers");
const package_1 = require("../utils/package");
function makeOxcResolverOptions(context, platform = "common") {
    const { alias, ...config } = (0, enhancedResolveHelpers_1.makeEnhancedResolveOptions)(context, platform);
    return {
        ...config,
        alias: alias
            ? Object.fromEntries(Object.entries(alias).map(([name, alias]) => [name, [alias]]))
            : {},
    };
}
const getOxcResolver = (() => {
    let sharedResolver;
    const resolvers = {};
    return (context, platform = "common") => {
        if (!resolvers[platform]) {
            const options = makeOxcResolverOptions(context, platform);
            if (!sharedResolver) {
                const { ResolverFactory } = (0, package_1.importResolver)("oxc-resolver");
                sharedResolver = new ResolverFactory(options);
                resolvers[platform] = sharedResolver;
            }
            else {
                resolvers[platform] = sharedResolver.cloneWithOptions(options);
            }
        }
        return resolvers[platform];
    };
})();
function applyOxcResolver(_resolve, context, moduleName, platform) {
    if (!platform) {
        return { type: "empty" };
    }
    const oxcResolve = getOxcResolver(context, platform);
    const { path: filePath } = oxcResolve.sync((0, enhancedResolveHelpers_1.getFromDir)(context), moduleName);
    if (!filePath) {
        return { type: "empty" };
    }
    if ((0, assets_1.isAssetFile)(context, moduleName)) {
        return (0, assets_1.resolveAsset)(context, filePath);
    }
    return {
        type: "sourceFile",
        filePath,
    };
}
//# sourceMappingURL=oxc-resolver.js.map