"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.remapLibToSrc = remapLibToSrc;
exports.resolveModule = resolveModule;
exports.resolveModulePath = resolveModulePath;
exports.remapImportPath = remapImportPath;
const tools_node_1 = require("@rnx-kit/tools-node");
const platform_1 = require("@rnx-kit/tools-react-native/platform");
const path = __importStar(require("node:path"));
const DEFAULT_OPTIONS = {
    extensions: [".ts", ".tsx"],
    mainFields: ["module", "main"],
};
function remapLibToSrc({ originModulePath }, ref, resolver) {
    const pattern = /^(.\/)?lib\b/;
    const { name, scope, path: modulePath } = ref;
    if (!modulePath || !pattern.test(modulePath)) {
        return undefined;
    }
    const fromDir = originModulePath
        ? path.dirname(originModulePath)
        : process.cwd();
    const packageName = scope ? `${scope}/${name}` : name;
    return resolver(fromDir, `${packageName}/${modulePath.replace(pattern, "src")}`);
}
function resolveModule(fromDir, moduleId, resolver, { mainFields }) {
    const manifestPath = resolver(fromDir, moduleId + "/package.json");
    const manifest = (0, tools_node_1.readPackage)(manifestPath);
    for (const mainField of mainFields) {
        const main = manifest[mainField];
        if (typeof main === "string") {
            return main;
        }
    }
    throw new Error(`A main field (e.g. ${mainFields.join(", ")}) is missing for '${moduleId}'`);
}
function resolveModulePath({ originModulePath }, ref, resolver, options) {
    if (ref.path) {
        return ref;
    }
    const fromDir = originModulePath
        ? path.dirname(originModulePath)
        : process.cwd();
    const { name, scope } = ref;
    const packageName = scope ? `${scope}/${name}` : name;
    const modulePath = resolveModule(fromDir, packageName, resolver, options);
    return {
        name,
        scope,
        path: modulePath.replace(/\.jsx?$/, ""),
    };
}
function remapImportPath(pluginOptions) {
    if (!pluginOptions) {
        throw new Error("A test function is required for this plugin");
    }
    const { test, ...options } = pluginOptions;
    if (typeof test !== "function") {
        throw new Error("Expected option `test` to be a function `(moduleId: string) => boolean`");
    }
    const resolverOptions = {
        ...DEFAULT_OPTIONS,
        ...options,
    };
    const getResolver = (() => {
        const { extensions, mainFields } = resolverOptions;
        let resolve;
        return (platform) => {
            if (!resolve) {
                resolve = require("enhanced-resolve").create.sync({
                    extensions: (0, platform_1.expandPlatformExtensions)(platform, extensions),
                    mainFields,
                });
            }
            return resolve;
        };
    })();
    return (context, moduleId, platform) => {
        const ref = (0, tools_node_1.parseModuleRef)(moduleId);
        if ((0, tools_node_1.isFileModuleRef)(ref) || !test(moduleId)) {
            return moduleId;
        }
        const resolve = getResolver(platform);
        const resolvedRef = resolveModulePath(context, ref, resolve, resolverOptions);
        return remapLibToSrc(context, resolvedRef, resolve) || moduleId;
    };
}
//# sourceMappingURL=remapImportPath.js.map