"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScreenReader = exports.announceForAccessibility = void 0;
var _react = require("react");
var _reactNative = require("react-native");
const useScreenReader = () => {
  const [isScreenReaderEnabled, setIsScreenReaderEnabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    _reactNative.AccessibilityInfo.isScreenReaderEnabled().then(setIsScreenReaderEnabled).catch(() => {
      setIsScreenReaderEnabled(false);
    });
  }, []);
  return isScreenReaderEnabled;
};
exports.useScreenReader = useScreenReader;
const announceForAccessibility = message => {
  _reactNative.AccessibilityInfo.announceForAccessibility(message);
};
exports.announceForAccessibility = announceForAccessibility;
//# sourceMappingURL=useScreenReader.js.map