import { useEffect, useState } from "react";
import { UniwindStore } from "../core/native/index.js";
import { StyleDependency } from "../types.js";
const getVariableValue = (name) => {
  return UniwindStore.vars[name];
};
let warned = false;
export const useCSSVariable = (name) => {
  const [value, setValue] = useState(getVariableValue(name));
  useEffect(() => {
    const updateValue = () => setValue(getVariableValue(name));
    const dispose = UniwindStore.subscribe(
      updateValue,
      [StyleDependency.Theme]
    );
    updateValue();
    return dispose;
  }, [name]);
  if (value === void 0 && __DEV__ && !warned) {
    warned = true;
    console.warn(
      `We couldn't find your variable ${name}. Make sure it's used at least once in your className, or define it in a static theme as described in the docs: https://docs.uniwind.dev/api/use-css-variable`
    );
  }
  return value;
};
