import "../../core/config";
import "./metro-injected";
const moveCssRulesToUtilitiesLayer = (sourceSheet) => {
  const layerRuleIndex = sourceSheet.insertRule(
    "@layer rnw {}",
    0
  );
  const layerRule = sourceSheet.cssRules[layerRuleIndex];
  while (sourceSheet.cssRules.length > 1) {
    const nextRule = sourceSheet.cssRules[1];
    layerRule.insertRule(nextRule.cssText, layerRule.cssRules.length);
    sourceSheet.deleteRule(1);
  }
};
if (typeof window !== "undefined" && typeof document !== "undefined") {
  const rnwStyleSheet = document.querySelector("#react-native-stylesheet");
  if (rnwStyleSheet?.sheet) {
    moveCssRulesToUtilitiesLayer(rnwStyleSheet.sheet);
  }
}
export const toRNWClassName = (className) => className !== void 0 ? { $$css: true, tailwind: className } : {};
