import { jsx } from "react/jsx-runtime";
import { TextInput as RNTextInput } from "react-native";
import { copyComponentProperties } from "../utils.js";
import { toRNWClassName } from "./rnw.js";
export const TextInput = copyComponentProperties(RNTextInput, (props) => {
  return /* @__PURE__ */ jsx(
    RNTextInput,
    {
      ...props,
      style: [toRNWClassName(props.className), props.style]
    }
  );
});
export default TextInput;
