import { jsx } from "react/jsx-runtime";
import { Modal as RNModal } from "react-native";
import { useUniwindAccent } from "../../hooks/index.js";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const Modal = copyComponentProperties(RNModal, (props) => {
  const style = useStyle(props.className);
  const backdropColor = useUniwindAccent(props.backdropColorClassName);
  return /* @__PURE__ */ jsx(
    RNModal,
    {
      ...props,
      style: [style, props.style],
      backdropColor: props.backdropColor ?? backdropColor
    }
  );
});
export default Modal;
