"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCSSVariable = void 0;
var _react = require("react");
var _web = require("../core/web");
const documentStyles = typeof document !== "undefined" ? window.getComputedStyle(document.documentElement) : null;
const getVariableValue = name => {
  if (!documentStyles) {
    return void 0;
  }
  const value = documentStyles.getPropertyValue(name).trim();
  if (value === "") {
    return void 0;
  }
  return (0, _web.parseCSSValue)(value);
};
let warned = false;
const useCSSVariable = name => {
  const [value, setValue] = (0, _react.useState)(getVariableValue(name));
  (0, _react.useEffect)(() => {
    const updateValue = () => setValue(getVariableValue(name));
    const themeListenerDispose = _web.CSSListener.addThemeListener(updateValue);
    const classListenerDispose = _web.CSSListener.addListener(":root", updateValue);
    updateValue();
    return () => {
      themeListenerDispose();
      classListenerDispose();
    };
  }, [name]);
  if (value === void 0 && __DEV__ && !warned) {
    warned = true;
    console.warn(`We couldn't find your variable ${name}. Make sure it's used at least once in your className, or define it in a static theme as described in the docs: https://docs.uniwind.dev/api/use-css-variable`);
  }
  return value;
};
exports.useCSSVariable = useCSSVariable;