"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyle = void 0;
var _react = require("react");
var _native = require("../../core/native");
const emptyState = {
  styles: {},
  dependencies: []
};
const useStyle = (className, state) => {
  const [_, rerender] = (0, _react.useReducer)(() => ({}), {});
  const styleState = (0, _react.useMemo)(() => className ? _native.UniwindStore.getStyles(className, state) : emptyState, [className, _, state?.isDisabled, state?.isFocused, state?.isPressed]);
  (0, _react.useEffect)(() => {
    if (__DEV__ || styleState.dependencies.length > 0) {
      const dispose = _native.UniwindStore.subscribe(() => rerender(), styleState.dependencies);
      return dispose;
    }
  }, [styleState]);
  return styleState.styles;
};
exports.useStyle = useStyle;