import { FetchWrapper } from '../utils/FetchWrapper';
export interface TrendingParams {
    country?: string;
    locale?: string;
    limit?: number;
}
export interface TrendingResponse {
    results: string[];
}
export declare class TrendingService {
    private fetchWrapper;
    constructor(fetchWrapper: FetchWrapper);
    /**
     * Fetches a list of the current trending search terms.
     *
     * @param params - An object containing the parameters for the request.
     * @returns A promise that resolves to a TrendingResponse containing the trending search terms.
     */
    getTrendingTerms(params?: TrendingParams): Promise<TrendingResponse>;
}
