"use strict";
// src/api/TenorClient.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenorClient = void 0;
const FetchWrapper_1 = require("../utils/FetchWrapper");
const SearchService_1 = require("./SearchService");
const FeaturedService_1 = require("./FeaturedService");
const SuggestionsService_1 = require("./SuggestionsService");
const AutocompleteService_1 = require("./AutocompleteService");
const TrendingService_1 = require("./TrendingService");
const RegisterShareService_1 = require("./RegisterShareService");
const PostsService_1 = require("./PostsService");
const CategoryService_1 = require("./CategoryService");
class TenorClient {
    constructor(apiKey, clientKey) {
        const baseUrl = 'https://tenor.googleapis.com/v2';
        const fetchWrapper = new FetchWrapper_1.FetchWrapper(baseUrl, apiKey, clientKey);
        this.search = new SearchService_1.SearchService(fetchWrapper);
        this.featured = new FeaturedService_1.FeaturedService(fetchWrapper);
        this.categories = new CategoryService_1.CategoryService(fetchWrapper);
        this.suggestions = new SuggestionsService_1.SuggestionsService(fetchWrapper);
        this.autocomplete = new AutocompleteService_1.AutocompleteService(fetchWrapper);
        this.trending = new TrendingService_1.TrendingService(fetchWrapper);
        this.registerShare = new RegisterShareService_1.RegisterShareService(fetchWrapper);
        this.posts = new PostsService_1.PostsService(fetchWrapper);
    }
}
exports.TenorClient = TenorClient;
