"use strict";
// src/api/PostsService.ts
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostsService = void 0;
class PostsService {
    constructor(fetchWrapper) {
        this.fetchWrapper = fetchWrapper;
    }
    /**
     * Fetches the GIFs, stickers, or a combination of the two for the specified IDs.
     *
     * @param params - An object containing the parameters for the request, including the IDs of the posts.
     * @returns A promise that resolves to a PostsResponse containing the requested media.
     */
    getPosts(params) {
        return __awaiter(this, void 0, void 0, function* () {
            const endpoint = 'posts';
            return this.fetchWrapper.get(endpoint, params);
        });
    }
}
exports.PostsService = PostsService;
