"use strict";
// src/api/FeaturedService.ts
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeaturedService = void 0;
class FeaturedService {
    constructor(fetchWrapper) {
        this.fetchWrapper = fetchWrapper;
    }
    /**
     * Fetches a list of current global featured GIFs or stickers from the Tenor API.
     *
     * @param params - An object containing the parameters for the request.
     * @returns A promise that resolves to a FeaturedResponse containing the featured GIFs or stickers.
     */
    getFeatured() {
        return __awaiter(this, arguments, void 0, function* (params = {}) {
            const endpoint = 'featured';
            return this.fetchWrapper.get(endpoint, params);
        });
    }
    /**
     * Fetches the next page of featured results based on the provided next token.
     *
     * @param next - The next page token from a previous featured response.
     * @returns A promise that resolves to a FeaturedResponse containing the next set of featured results.
     */
    fetchNext(next) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.getFeatured({ pos: next });
        });
    }
}
exports.FeaturedService = FeaturedService;
