"use strict";
// src/api/CategoryService.ts
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryService = void 0;
class CategoryService {
    constructor(fetchWrapper) {
        this.fetchWrapper = fetchWrapper;
    }
    /**
     * Fetches a list of GIF categories associated with the provided type.
     *
     * @param params - An object containing the parameters for the request.
     * @returns A promise that resolves to a CategoriesResponse containing the list of categories.
     */
    getCategories() {
        return __awaiter(this, arguments, void 0, function* (params = {}) {
            const endpoint = 'categories';
            return this.fetchWrapper.get(endpoint, params);
        });
    }
}
exports.CategoryService = CategoryService;
