"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startProfiling = startProfiling;
exports.stopProfiling = stopProfiling;
var _reactNative = require("react-native");
const LINKING_ERROR = `The package 'react-native-release-profiler' doesn't seem to be linked. Make sure: \n\n` + _reactNative.Platform.select({
  ios: "- You have run 'pod install'\n",
  default: ''
}) + '- You rebuilt the app after installing the package\n' + '- You are not using Expo Go\n';
const ReleaseProfiler = _reactNative.NativeModules.ReleaseProfiler ? _reactNative.NativeModules.ReleaseProfiler : new Proxy({}, {
  get() {
    throw new Error(LINKING_ERROR);
  }
});
function startProfiling() {
  return ReleaseProfiler.startProfiling();
}
async function stopProfiling(saveToDownloads = false, _fileName = '') {
  if (saveToDownloads && _reactNative.Platform.OS === 'android' && _reactNative.Platform.Version < 29) {
    const result = await _reactNative.PermissionsAndroid.request(_reactNative.PermissionsAndroid.PERMISSIONS.WRITE_EXTERNAL_STORAGE);
    if (!result) {
      throw new Error('WRITE_EXTERNAL_STORAGE permission is required to save to downloads.');
    }
  }
  return await ReleaseProfiler.stopProfiling(saveToDownloads);
}
//# sourceMappingURL=index.js.map