//
//  RNKCKeyboardBackgroundViewComponentDescriptor.h
//  Pods
//
//  Created by Kiryl Ziusko on 18/05/2025.
//

#pragma once

#include "RNKCKeyboardBackgroundViewShadowNode.h"

#include <react/debug/react_native_assert.h>
#include <react/renderer/components/reactnativekeyboardcontroller/Props.h>
#include <react/renderer/core/ConcreteComponentDescriptor.h>

namespace facebook::react {
class KeyboardBackgroundViewComponentDescriptor final
    : public ConcreteComponentDescriptor<KeyboardBackgroundViewShadowNode> {
 public:
  using ConcreteComponentDescriptor::ConcreteComponentDescriptor;
  void adopt(ShadowNode &shadowNode) const override {
    react_native_assert(dynamic_cast<KeyboardBackgroundViewShadowNode *>(&shadowNode));
    ConcreteComponentDescriptor::adopt(shadowNode);
  }
};

} // namespace facebook::react
