"use strict";

import React from 'react';
import { View } from 'react-native';
import useSymbolicMarkerRendererProps from "./useSymbolicMarkerRendererStyles.js";
export default function DisclosureClosedSymbolRenderer(props) {
  const {
    prefixStyle: {
      top
    },
    prefixSize
  } = useSymbolicMarkerRendererProps(props, 1);
  return /*#__PURE__*/React.createElement(View, {
    style: {
      top,
      width: 0,
      height: 0,
      borderStyle: 'solid',
      borderLeftWidth: prefixSize,
      borderLeftColor: props.color,
      borderTopWidth: prefixSize / 2,
      borderTopColor: 'transparent',
      borderBottomWidth: prefixSize / 2,
      borderBottomColor: 'transparent'
    }
  });
}
//# sourceMappingURL=DisclosureClosedSymbolRenderer.js.map