"use strict";

import pick from 'ramda/src/pick';
const extractProps = pick(['resizeMode', 'tintColor', 'overlayColor', 'borderBottomLeftRadius', 'borderBottomRightRadius', 'borderTopLeftRadius', 'borderTopRightRadius']);
function mapObjectFit(objectFit) {
  let resizeMode;
  switch (objectFit) {
    case 'contain':
    case 'cover':
      resizeMode = objectFit;
      break;
    case 'fill':
      resizeMode = 'stretch';
      break;
    case 'scale-down':
      resizeMode = 'contain';
      break;
    default:
      return null;
  }
  return {
    resizeMode
  };
}
function extractImageStyleProps(style, objectFit) {
  const resizeModeFromFit = objectFit ? mapObjectFit(objectFit) : null;
  return {
    ...extractProps(style),
    ...resizeModeFromFit
  };
}
export default extractImageStyleProps;
//# sourceMappingURL=extractImageStyleProps.js.map