"use strict";

import { useCallback } from 'react';
import { Image } from 'react-native';
import { jsx as _jsx } from "react/jsx-runtime";
const defaultImageStyle = {
  resizeMode: 'cover'
};

/**
 * Default success "image" view for the {@link IMGElement} component.
 */
export default function IMGElementContentSuccess({
  source,
  imageStyle,
  dimensions,
  onError
}) {
  const onImageError = useCallback(({
    nativeEvent: {
      error
    }
  }) => onError(error), [onError]);
  return /*#__PURE__*/_jsx(Image, {
    source: source,
    onError: onImageError,
    style: [defaultImageStyle, dimensions, imageStyle],
    testID: "image-success"
  });
}
//# sourceMappingURL=IMGElementContentSuccess.js.map