"use strict";

import React from 'react';
import useIMGElementState from "./useIMGElementState.js";
import IMGElementContentSuccess from "./IMGElementContentSuccess.js";
import IMGElementContainer from "./IMGElementContainer.js";
import IMGElementContentLoading from "./IMGElementContentLoading.js";
import IMGElementContentError from "./IMGElementContentError.js";
import { jsx as _jsx } from "react/jsx-runtime";
/**
 * A component to render images based on an internal loading state.
 *
 * @remarks This component will attempt to draw a box of paint dimensions
 * before retrieving the physical dimensions of the image to avoid layout
 * shifts. See also {@link useIMGElementState}, {@link IMGElementContainer},
 * {@link IMGElementContentSuccess}, {@link IMGElementContentLoading}
 * and {@link IMGElementContentError} for customization.
 */
function IMGElement(props) {
  const state = useIMGElementState(props);
  let content;
  if (state.type === 'success') {
    content = /*#__PURE__*/React.createElement(IMGElementContentSuccess, state);
  } else if (state.type === 'loading') {
    content = /*#__PURE__*/React.createElement(IMGElementContentLoading, state);
  } else {
    content = /*#__PURE__*/React.createElement(IMGElementContentError, state);
  }
  return /*#__PURE__*/_jsx(IMGElementContainer, {
    testID: props.testID,
    ...props.containerProps,
    onPress: props.onPress,
    style: state.containerStyle,
    children: content
  });
}
export default IMGElement;
//# sourceMappingURL=IMGElement.js.map