"use strict";

import React, { useMemo } from 'react';
import mergeDeepRight from 'ramda/src/mergeDeepRight';
import defaultRendererProps from "./defaultRendererProps.js";
import useProfiler from "../hooks/useProfiler.js";
const RenderersPropsContext = /*#__PURE__*/React.createContext(defaultRendererProps);

/**
 * Consume props from {@link RenderHTMLProps.renderersProps}.
 *
 * @param tagName - The name of the element.
 * @typeParam K - The type literal corresponding to the element name.
 * @returns props for this renderer.
 *
 * @public
 */
export function useRendererProps(tagName) {
  const userProps = React.useContext(RenderersPropsContext);
  return userProps[tagName];
}

/**
 * @internal
 */
export default function RenderersPropsProvider(props) {
  const profile = useProfiler({
    prop: 'renderersProps'
  });
  const mergedRenderersProps = useMemo(() => {
    typeof __DEV__ === 'boolean' && __DEV__ && profile();
    return mergeDeepRight(defaultRendererProps, props.renderersProps || {});
  }, [props.renderersProps, profile]);
  return /*#__PURE__*/React.createElement(RenderersPropsContext.Provider, {
    value: mergedRenderersProps
  }, props.children);
}
//# sourceMappingURL=RenderersPropsProvider.js.map