"use strict";

import { useContext } from 'react';
import ttreeEventsContext from "./context/ttreeEventsContext.js";
import useTTree from "./hooks/useTTree.js";
import TDocumentRenderer from "./TDocumentRenderer.js";
import { jsx as _jsx } from "react/jsx-runtime";
export default function RenderTTree(props) {
  const ttree = useTTree(props);
  const {
    onDocumentMetadataLoaded
  } = useContext(ttreeEventsContext);
  return /*#__PURE__*/_jsx(TDocumentRenderer, {
    tdoc: ttree,
    baseUrl: props.baseUrl,
    onDocumentMetadataLoaded: onDocumentMetadataLoaded
  });
}
//# sourceMappingURL=RenderTTree.js.map