"use strict";

import { Platform, TouchableHighlight, TouchableNativeFeedback, View } from 'react-native';
import { useSharedProps } from "./context/SharedPropsProvider.js";
import { jsx as _jsx } from "react/jsx-runtime";
export default function GenericPressable({
  style,
  children,
  borderless = false,
  ...otherProps
}) {
  const {
    pressableHightlightColor,
    GenericPressable: UserProvidedPressable
  } = useSharedProps();
  if (UserProvidedPressable) {
    return /*#__PURE__*/_jsx(UserProvidedPressable, {
      style: style,
      borderless: borderless,
      ...otherProps,
      children: children
    });
  }
  if (Platform.OS === 'android') {
    // TouchableNativeFeedback does not support a
    // style prop. So we must wrap it inside a View.
    return /*#__PURE__*/_jsx(View, {
      style: style,
      children: /*#__PURE__*/_jsx(TouchableNativeFeedback, {
        useForeground: true,
        background: TouchableNativeFeedback.Ripple(pressableHightlightColor, borderless),
        ...otherProps,
        children: /*#__PURE__*/_jsx(View, {
          testID: "generic-pressable",
          children: children
        })
      })
    });
  }
  return /*#__PURE__*/_jsx(TouchableHighlight, {
    underlayColor: pressableHightlightColor,
    style: style,
    ...otherProps,
    children: /*#__PURE__*/_jsx(View, {
      testID: "generic-pressable",
      children: children
    })
  });
}
//# sourceMappingURL=GenericPressable.js.map