---
layout: home
sidebar: false

title: HouseForm
titleTemplate: Simple to use field-first React forms

hero:
  name: HouseForm
  text: Field-First React Form Validation
  tagline: Where your form validation and UI code live together in harmony.
  image:
    src: /logo-with-shadow.svg
    alt: HouseForm
  actions:
    - theme: brand
      text: Get Started
      link: /introduction
    - theme: alt
      text: Comparisons
      link: /comparison
    - theme: alt
      text: View on GitHub
      link: https://github.com/houseform/houseform

features:
  - icon: ✏️
    title: Field First
    details: Consolidate your UI and validation logic in one location - your fields.
  - icon: 📱
    title: Headless & runtime agnostic
    details: Use HouseForm in any React supported environment, from native apps to the CLI.
  - icon: 💎
    title: Zod Powered
    details: Easily setup complex validations for your form fields.
  - icon: 🤸‍♀️
    title: Flexible API
    details: Mix and match which validation methods work best per-field.
  - icon: 🪶
    title: Lightweight
    details: HouseForm has a bundle less than 4KB GZIP in size.
  - icon: 🏎️
    title: Fast
    details: Our benchmarks have us on-par or faster than common alternatives.
---
