import React, { ForwardedRef } from "react";
import { FormInstance } from "./types";
export interface FormProps<T> {
    onSubmit?: (values: T, form: FormInstance<T>) => void;
    children: (props: FormInstance<T>) => JSX.Element;
    memoChild?: any[];
    submitWhenInvalid?: boolean;
}
declare function FormComp<T extends Record<string, any> = Record<string, any>>(props: FormProps<T>, ref: ForwardedRef<FormInstance<T>>): JSX.Element;
export declare const Form: <T = Record<string, any>>(props: FormProps<T> & {
    ref?: React.ForwardedRef<FormInstance<T>> | undefined;
}) => ReturnType<typeof FormComp>;
export {};
