import type { NativeTabsTriggerTabBarProps } from './types';
/**
 * The component used to customize the style of the tab bar, when given trigger is selected.
 *
 * Prefer this to global changes of tab bar styles, directly in the page.
 *
 * > **Note:** You can use the alias `NativeTabs.Trigger.TabBar` for this component.
 *
 * @example
 * ```tsx
 * <NativeTabs
 *  backgroundColor="black"
 * >
 *  <NativeTabs.Trigger name="page">
 *    <NativeTabs.Trigger.TabBar
 *      backgroundColor="white"
 *    />
 *    <Label>Page</Label>
 *  </NativeTabs.Trigger>
 * </NativeTabs>
 *
 */
export declare function NativeTabsTriggerTabBar(props: NativeTabsTriggerTabBarProps): React.ReactNode;
//# sourceMappingURL=NativeTabsTriggerTabBar.d.ts.map