import { LinkingOptions } from '@react-navigation/native';
import { RouteNode } from './Route';
import { UrlObject } from './global-state/routeInfo';
import type { StoreRedirects } from './global-state/router-store';
import { getInitialURL, getPathFromState, getStateFromPath } from './link/linking';
import { RequireContext } from './types';
export declare function getNavigationConfig(routes: RouteNode, metaOnly: boolean, { sitemap, notFound }: {
    sitemap: boolean;
    notFound: boolean;
}): {
    screens: {
        __root: {
            initialRouteName: undefined;
            screens: Record<string, import("./getReactNavigationConfig").Screen>;
            path: string;
        };
    } | {
        __root: {
            initialRouteName: undefined;
            screens: Record<string, import("./getReactNavigationConfig").Screen>;
            path: string;
        };
    } | {
        __root: {
            initialRouteName: undefined;
            screens: Record<string, import("./getReactNavigationConfig").Screen>;
            path: string;
        };
    } | {
        __root: {
            initialRouteName: undefined;
            screens: Record<string, import("./getReactNavigationConfig").Screen>;
            path: string;
        };
    };
};
export type ExpoLinkingOptions<T extends object = Record<string, unknown>> = LinkingOptions<T> & {
    getPathFromState: typeof getPathFromState;
    getStateFromPath: typeof getStateFromPath;
};
export type LinkingConfigOptions = {
    metaOnly?: boolean;
    serverUrl?: string;
    getInitialURL?: typeof getInitialURL;
    redirects?: StoreRedirects[];
};
interface RouterOptions {
    skipGenerated: boolean;
    sitemap: boolean;
    notFound: boolean;
}
export declare function getLinkingConfig(routes: RouteNode, context: RequireContext, getRouteInfo: () => UrlObject, { metaOnly, serverUrl, redirects, skipGenerated, sitemap, notFound, }: LinkingConfigOptions & RouterOptions): ExpoLinkingOptions;
export {};
//# sourceMappingURL=getLinkingConfig.d.ts.map