import { c as createStoreTransition } from './store-2bd0db75.esm.js';
export { f as createAsyncAtom, e as createAtom, a as createStore, d as createStoreConfig, b as createStoreWithProducer } from './store-2bd0db75.esm.js';

// From https://github.com/reduxjs/react-redux/blob/720f0ba79236cdc3e1115f4ef9a7760a21784b48/src/utils/shallowEqual.ts
function is(x, y) {
  if (x === y) {
    return x !== 0 || y !== 0 || 1 / x === 1 / y;
  } else {
    return x !== x && y !== y;
  }
}
function shallowEqual(objA, objB) {
  if (is(objA, objB)) return true;
  if (typeof objA !== 'object' || objA === null || typeof objB !== 'object' || objB === null) {
    return false;
  }
  const keysA = Object.keys(objA);
  const keysB = Object.keys(objB);
  if (keysA.length !== keysB.length) return false;
  for (let i = 0; i < keysA.length; i++) {
    if (!Object.prototype.hasOwnProperty.call(objB, keysA[i]) || !is(objA[keysA[i]], objB[keysA[i]])) {
      return false;
    }
  }
  return true;
}

/**
 * An actor logic creator which creates store [actor
 * logic](https://stately.ai/docs/actors#actor-logic) for use with XState.
 *
 * @param config An object containing the store configuration
 * @param config.context The initial context for the store, either a function
 *   that returns context based on input, or the context itself
 * @param config.on An object defining the transitions for different event types
 * @param config.emits Optional object to define emitted event handlers
 * @returns An actor logic creator function that creates store actor logic
 */
function fromStore(config) {
  const initialContext = config.context;
  const transitionsObj = config.on;
  const transition = createStoreTransition(transitionsObj);
  return {
    transition: (snapshot, event, actorScope) => {
      const [nextSnapshot, effects] = transition(snapshot, event);
      for (const effect of effects) {
        if (typeof effect === 'function') {
          effect();
        } else {
          actorScope.emit(effect);
        }
      }
      return nextSnapshot;
    },
    getInitialSnapshot: (_, input) => {
      return {
        status: 'active',
        context: typeof initialContext === 'function' ? initialContext(input) : initialContext,
        output: undefined,
        error: undefined
      };
    },
    getPersistedSnapshot: s => s,
    restoreSnapshot: s => s
  };
}

export { fromStore, shallowEqual };
