#pragma once

#include <memory>
#include <utility>

#include <jsi/jsi.h>

#include "JsiSkHostObjects.h"

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdocumentation"

#include "include/core/SkPathEffect.h"

#pragma clang diagnostic pop

namespace RNSkia {

namespace jsi = facebook::jsi;

class JsiSkPathEffect : public JsiSkWrappingSkPtrHostObject<SkPathEffect> {
public:
  JsiSkPathEffect(std::shared_ptr<RNSkPlatformContext> context,
                  sk_sp<SkPathEffect> pathEffect)
      : JsiSkWrappingSkPtrHostObject<SkPathEffect>(std::move(context),
                                                   std::move(pathEffect)) {}

  size_t getMemoryPressure() const override { return 2048; }

  EXPORT_JSI_API_TYPENAME(JsiSkPathEffect, PathEffect)
  JSI_EXPORT_FUNCTIONS(JSI_EXPORT_FUNC(JsiSkPathEffect, dispose))
};

} // namespace RNSkia
